<?php
if (!defined('FW')){
	die('Forbidden');
}

$info ='<p class="fpr-info">';
$info .= esc_html__('Full page rows options set requires page builder to be active and have sections.','creatus');
$info .='<br />';
$info .= esc_html__('To add scroll menu, go to Content Elements tab in page builder and add Sections menu element.','creatus');
$info .='</p>';

$options = array(
	'fp' => array(
		'type' => 'thz-multi-options',
		'label' => __('Full page rows metrics', 'creatus'),
		'desc' => esc_html__('Adjust full page rows metrics. See help for more info.', 'creatus'),
		'help' => esc_html__('Anchor in URL adds the current row anchor to page url. Best setup for Parallax Out animation is, Speed:800, Easing:easeInOutCubic. Overflow scroll option will let your scroll over the overflowing content and than continue the animation.', 'creatus'),
		'value' => array(
			'animation' => 'none',
			'speed' 	=> 600,
			'easing' 	=> 'easeInOutCubic',
			'scrollbars' => 'show',
			'overflow' 	=> 'disable',
			'hash'		=>'disable',
			'mob'		=>'disable'
		),
		'thz_options' => array(
			'animation' => array(
				'type' => 'short-select',
				'title' => esc_html__('Scroll animation', 'creatus'),
				'choices' => array(
					'none' => esc_html__('Default', 'creatus'),
					'thz-OutZoomRollOut' => esc_html__('Zoom Roll Out', 'creatus'),
					'thz-OutZoomFadeScaleOut' => esc_html__('Zoom Fade Scale Out', 'creatus'),
					'thz-OutFadeOut' => esc_html__('Fade Out', 'creatus'),
					'thz-OutChaseOut' => esc_html__('Chase Out', 'creatus'),
					'thz-OutScalePauseOut' => esc_html__('Scale Pause Out', 'creatus'),
					'thz-OutParallaxOut' => esc_html__('Parallax Out', 'creatus'),
				),
			),
			'speed' => array(
				'type' => 'spinner',
				'title' => esc_html__('Scroll speed', 'creatus'),
				'addon' => 'ms',
				'min' => 0,
				'max' => 2000,
				'step' => 100,
			),
			'easing' => array(
				'type' => 'short-select',
				'title' => esc_html__('Easing', 'creatus'),
				'choices' => array(
					'easeInCubic' => esc_html__('easeInCubic', 'creatus'),
					'easeOutCubic' => esc_html__('easeOutCubic', 'creatus'),
					'easeInOutCubic' => esc_html__('easeInOutCubic', 'creatus'),
					'easeInQuint' => esc_html__('easeInQuint', 'creatus'),
					'easeOutQuint' => esc_html__('easeOutQuint', 'creatus'),
					'easeInOutQuint' => esc_html__('easeInOutQuint', 'creatus'),
					'easeInSine' => esc_html__('easeInSine', 'creatus'),
					'easeOutSine' => esc_html__('easeOutSine', 'creatus'),
					'easeInOutSine' => esc_html__('easeInOutSine', 'creatus'),
					'easeInQuad' => esc_html__('easeInQuad', 'creatus'),
					'easeOutQuad' => esc_html__('easeOutQuad', 'creatus'),
					'easeInOutQuad' => esc_html__('easeInOutQuad', 'creatus'),
					'easeInExpo' => esc_html__('easeInExpo', 'creatus'),
					'easeInCirc' => esc_html__('easeInCirc', 'creatus'),
					'easeOutCirc' => esc_html__('easeOutCirc', 'creatus'),
					'easeInOutCirc' => esc_html__('easeInOutCirc', 'creatus'),
				),
			),
			'scrollbars' => array(
				'type' => 'short-select',
				'title' => esc_html__('Hide scrollbar', 'creatus'),
				'choices' => array(
					'show' => esc_html__('Do not hide', 'creatus'),
					'hide' => esc_html__('Hide', 'creatus'),
				),
			),
			'overflow' => array(
				'type' => 'short-select',
				'title' => esc_html__('Overflow scroll', 'creatus'),
				'choices' => array(
					'enable' => esc_html__('Enable', 'creatus'),
					'disable' => esc_html__('Disable', 'creatus'),
				),
			),
			'hash' => array(
				'type' => 'short-select',
				'title' => esc_html__('Anchor in URL', 'creatus'),
				'choices' => array(
					'enable' => esc_html__('Enable', 'creatus'),
					'disable' => esc_html__('Disable', 'creatus'),
				),
			),	
			
			'mob' => array(
				'type' => 'short-select',
				'title' => esc_html__('On mobiles', 'creatus'),
				'choices' => array(
					'enable' => esc_html__('Enable', 'creatus'),
					'disable' => esc_html__('Disable', 'creatus'),
				),
			),		
		)
	),

	'bg' => array(
		'type' => 'thz-box-style',
		'label' => __('Rows background', 'creatus'),
		'desc' => esc_html__('Adjust .thz-page-builder-content background.', 'creatus'),
		'preview' => true,
		'popup' => true,
		'button-text' => esc_html__('Customize rows background', 'creatus'),
		'disable' => array('layout','transform','boxsize','padding','margin','borders','borderradius','boxshadow','video',''),
		'value' => array(),
	),
	
	'ra' => array(
		'label' => __('Replay animations', 'creatus'),
		'desc' => __('Replay row items animations. See help for more info.', 'creatus'),
		'help' => __('Any row can contain items that animate when in view. This option can replay these animations when you scroll back to that row.', 'creatus'),
		'type' => 'switch',
		'right-choice' => array(
			'value' => 'no',
			'label' => __('Do not replay animations', 'creatus')
		),
		'left-choice' => array(
			'value' => 'replay',
			'label' => __('Replay animations', 'creatus')
		),
		'value' => 'replay'
	),
	
	'i' => array(
		'label' => false,
		'type'  => 'thz-html',
		'html'  => $info,
	),
);